#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "Gamma Fit of Oil1 C10+ Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    132.89      137.80      138.07     8.8248e-02    8.8212e-02    4.1421e-02    4.1485e-02
    144.11      150.60      150.32     7.3527e-02    7.7933e-02    3.7718e-02    3.9903e-02
    156.87      163.30      163.07     6.5591e-02    6.7246e-02    3.6483e-02    3.7352e-02
    169.53      175.90      175.70     6.2953e-02    5.9639e-02    3.7718e-02    3.5692e-02
    182.09      188.41      188.23     5.6635e-02    5.3577e-02    3.6346e-02    3.4351e-02
    194.57      200.84      200.68     5.3730e-02    4.8504e-02    3.6758e-02    3.3155e-02
    206.97      213.20      213.05     4.7028e-02    4.4141e-02    3.4152e-02    3.2032e-02
    219.30      225.48      225.34     3.9644e-02    4.0324e-02    3.0448e-02    3.0951e-02
    231.55      237.70      237.57     3.9639e-02    3.6947e-02    3.2094e-02    2.9898e-02
    243.74      249.86      249.73     3.7549e-02    3.3934e-02    3.1957e-02    2.8865e-02
    255.87      261.95      261.83     2.9513e-02    3.1228e-02    2.6334e-02    2.7850e-02
    267.94      273.99      273.87     2.7041e-02    2.8786e-02    2.5237e-02    2.6853e-02
    279.95      285.97      285.85     2.4923e-02    2.6574e-02    2.4277e-02    2.5875e-02
    291.91      297.90      297.79     2.3114e-02    2.4564e-02    2.3454e-02    2.4915e-02
    303.81      309.77      309.67     2.1188e-02    2.2731e-02    2.2356e-02    2.3977e-02
    315.67      321.60      321.50     2.0158e-02    2.1057e-02    2.2082e-02    2.3060e-02
    327.48      333.39      333.29     1.7754e-02    1.9524e-02    2.0162e-02    2.2165e-02
    339.24      345.13      345.03     1.7034e-02    1.8119e-02    2.0025e-02    2.1294e-02
    350.96      356.83      356.73     1.6362e-02    1.6828e-02    1.9888e-02    2.0448e-02
    362.64      368.49      368.39     1.6173e-02    1.5640e-02    2.0299e-02    1.9625e-02
    374.28      555.97      550.07     2.2220e-01    2.2429e-01    4.2079e-01    4.2025e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_001_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Lab2 Constant Composition Expansion"
show title

$Expt << END
#           Pres          Rel Vol         Liq Den (kg/m3)       Liq Vis (cp)
#  Stg     (barg)      Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------------   ------------------   ------------------
     1     379.21     0.9761  0.9717      706.80  707.39      0.47600  0.59485
     2     344.74     0.9819  0.9781      702.60  702.75      0.45600  0.55982
     3     310.26     0.9879  0.9851      698.40  697.73      0.43400  0.52477
     4     275.79     0.9943  0.9929      693.90  692.29      0.41300  0.48976
     5     268.90     0.9956  0.9945      692.90  691.15      0.40900  0.48277
     6     262.00     0.9970  0.9962      692.00  689.99      0.40400  0.47576
     7     255.11     0.9983  0.9979      691.10  688.80      0.40000  0.46878
     8     246.83     1.0000  1.0000      689.90  687.35      0.39500  0.46038
     9     236.35     1.0115  1.0124         NaN  691.75          NaN  0.48052
    10     215.94     1.0389  1.0418         NaN  700.41          NaN  0.52305
    11     194.09     1.0777  1.0831         NaN  709.77          NaN  0.57365
    12     170.37     1.1359  1.1443         NaN  720.10          NaN  0.63564
    13     148.10     1.2139  1.2254         NaN  730.02          NaN  0.70193
    14     126.93     1.3210  1.3357         NaN  739.72          NaN  0.77377
    15     108.32     1.4583  1.4757         NaN  748.54          NaN  0.84555
    16      90.32     1.6556  1.6750         NaN  757.41          NaN  0.92441
    17      81.91     1.7821  1.8019         NaN  761.70          NaN  0.96507
END
set xlabel "Pressure (barg)"
set ylabel "Relative Volume"
set output "Figures/Expt_002_RV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "Lab2 Differential Liberation"
show title

$Expt << END
#           Temp       Pres                    Liq Vol (m3)       Removed (sm3)      Liq Den (kg/m3)      Liq Vis (cp)       Gas Z-Factor      Gas Sp Gravity        Gas Vis (cp)
#  Stg       (C)      (barg)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc        Expt      Calc
#------   --------   --------   ----------   ----------------   ----------------   ------------------   ----------------   ----------------   ----------------   --------------------
     1     100.00     379.21       1.00       1.4660  1.4594        NaN    0.00      706.80  707.39      0.4760  0.5948        NaN  1.0376        NaN  0.9122          NaN  0.038318
     2     100.00     344.74       1.00       1.4750  1.4691        NaN    0.00      702.60  702.75      0.4560  0.5598        NaN  0.9925        NaN  0.8650          NaN  0.034025
     3     100.00     310.26       1.00       1.4840  1.4797        NaN    0.00      698.40  697.73      0.4340  0.5248        NaN  0.9551        NaN  0.8265          NaN  0.030291
     4     100.00     275.79       1.00       1.4930  1.4913        NaN    0.00      693.90  692.29      0.4130  0.4898        NaN  0.9249        NaN  0.7950          NaN  0.026941
     5     100.00     268.90       1.00       1.4950  1.4937        NaN    0.00      692.90  691.15      0.4090  0.4828        NaN  0.9197        NaN  0.7895          NaN  0.026310
     6     100.00     262.00       1.00       1.4970  1.4963        NaN    0.00      692.00  689.99      0.4040  0.4758        NaN  0.9147        NaN  0.7841          NaN  0.025690
     7     100.00     255.11       1.00       1.4990  1.4988        NaN    0.00      691.10  688.80      0.4000  0.4688        NaN  0.9101        NaN  0.7790          NaN  0.025083
     8     100.00     246.83       1.00       1.5020  1.5020       0.00    0.00      689.90  687.35      0.3950  0.4604        NaN  0.9049        NaN  0.7731          NaN  0.024370
     9     100.00     220.63       1.00       1.4550  1.4528      18.34   19.15      700.10  698.42      0.4250  0.5129     0.8780  0.8913     0.7920  0.7565     0.022900  0.022234
    10     100.00     193.05       1.00       1.4110  1.4046      35.95   37.93      710.20  710.28      0.4730  0.5767     0.8670  0.8818     0.7650  0.7423     0.020700  0.020196
    11     100.00     165.47       1.00       1.3700  1.3594      52.49   55.47      720.20  722.36      0.5380  0.6508     0.8640  0.8774     0.7490  0.7315     0.019000  0.018401
    12     100.00     137.90       1.00       1.3320  1.3167      68.14   71.94      730.20  734.71      0.6170  0.7370     0.8690  0.8785     0.7430  0.7247     0.017500  0.016869
    13     100.00     110.32       1.00       1.2950  1.2759      83.43   87.51      740.00  747.38      0.7080  0.8375     0.8790  0.8853     0.7510  0.7233     0.016200  0.015601
    14     100.00      82.74       1.00       1.2590  1.2367      98.37  102.31      750.00  760.42      0.8310  0.9548     0.8940  0.8978     0.7720  0.7301     0.015100  0.014578
    15     100.00      55.16       1.00       1.2230  1.1979     112.95  116.59      760.70  774.02      1.0360  1.0924     0.9130  0.9162     0.7930  0.7538     0.014100  0.013745
    16     100.00      27.58       1.00       1.1830  1.1568     128.42  131.01      772.30  788.85      1.4090  1.2599     0.9380  0.9407     0.8870  0.8307     0.012900  0.012946
    17     100.00      11.86       1.00       1.1520  1.1282     138.74  140.21      781.70  798.92      1.7390  1.3834     0.9630  0.9574     1.0470  1.0005     0.012400  0.012185
    18     100.00       0.00       0.00       1.0710  1.0317     157.59  161.17      802.30  823.25      2.0560  1.7812     1.0000  0.9853     1.7690  2.0275     0.009500  0.009746
    19      15.60       0.00       0.00       1.0000  0.9878        NaN  161.17      858.60  859.88         NaN  3.1025        NaN  0.9981        NaN  1.0214          NaN  0.014995
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_003_LV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_003_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_003_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_003_LVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_003_GZ_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_003_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_003_GVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Oil1 Phase Envelope"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   51.485     1.00000e-13        0.00000         2.18922e-15         1.00000        550.068     237.902     0.930888     8.81392e-16     2.51258e-17
   52.500     1.21706e-13        0.00000         2.65672e-15         1.00000        550.068     237.902     0.930670     1.06936e-15     3.05500e-17
   55.000     1.96245e-13        0.00000         4.25368e-15         1.00000        550.068     237.902     0.930129     1.71116e-15     4.91486e-17
   57.500     3.13763e-13        0.00000         6.75348e-15         1.00000        550.068     237.902     0.929583     2.71518e-15     7.84146e-17
   60.000     4.97522e-13        0.00000         1.06346e-14         1.00000        550.068     237.902     0.929033     4.27304e-15     1.24095e-16
   62.500     7.82554e-13        0.00000         1.66126e-14         1.00000        550.068     237.902     0.928479     6.67101e-15     1.94836e-16
   65.000     1.22121e-12        0.00000         2.57486e-14         1.00000        550.067     237.902     0.927920     1.03335e-14     3.03544e-16
   67.500     1.89114e-12        0.00000         3.96050e-14         1.00000        550.067     237.902     0.927356     1.58847e-14     4.69345e-16
   70.000     2.90663e-12        0.00000         6.04654e-14         1.00000        550.067     237.902     0.926788     2.42365e-14     7.20373e-16
   72.500     4.43471e-12        0.00000         9.16429e-14         1.00000        550.067     237.902     0.926216     3.67108e-14     1.09772e-15
   75.000     6.71777e-12        0.00000         1.37911e-13         1.00000        550.067     237.902     0.925638     5.52107e-14     1.66099e-15
   77.500     1.01051e-11        0.00000         2.06100e-13         1.00000        550.067     237.902     0.925057     8.24574e-14     2.49605e-15
   80.000     1.50965e-11        0.00000         3.05919e-13         1.00000        550.067     237.902     0.924470     1.22316e-13     3.72581e-15
   82.500     2.24030e-11        0.00000         4.51077e-13         1.00000        550.067     237.902     0.923879     1.80239e-13     5.52500e-15
   85.000     3.30288e-11        0.00000         6.60806e-13         1.00000        550.067     237.902     0.923282     2.63871e-13     8.14055e-15
   87.500     4.83836e-11        0.00000         9.61927e-13         1.00000        550.067     237.902     0.922682     3.83863e-13     1.19192e-14
   90.000     7.04346e-11        0.00000         1.39160e-12         1.00000        550.067     237.902     0.922076     5.54963e-13     1.73450e-14
   92.500     1.01910e-10        0.00000         2.00102e-12         1.00000        550.067     237.902     0.921465     7.97469e-13     2.50895e-14
   95.000     1.46569e-10        0.00000         2.86030e-12         1.00000        550.067     237.902     0.920850     1.13916e-12     3.60793e-14
   97.500     2.09570e-10        0.00000         4.06489e-12         1.00000        550.067     237.902     0.920229     1.61781e-12     5.15856e-14
  100.000     2.97937e-10        0.00000         5.74408e-12         1.00000        550.066     237.902     0.919603     2.28457e-12     7.33427e-14
  102.500     4.21196e-10        0.00000         8.07195e-12         1.00000        550.066     237.902     0.918973     3.20823e-12     1.03704e-13
  105.000     5.92189e-10        0.00000         1.12817e-11         1.00000        550.066     237.902     0.918337     4.48085e-12     1.45847e-13
  107.500     8.28140e-10        0.00000         1.56841e-11         1.00000        550.066     237.902     0.917696     6.22504e-12     2.04037e-13
  110.000     1.15203e-09        0.00000         2.16911e-11         1.00000        550.065     237.902     0.917050     8.60317e-12     2.83974e-13
  112.500     1.59436e-09        0.00000         2.98461e-11         1.00000        550.065     237.902     0.916399     1.18292e-11     3.93239e-13
  115.000     2.19543e-09        0.00000         4.08626e-11         1.00000        550.065     237.902     0.915743     1.61839e-11     5.41859e-13
  117.500     3.00821e-09        0.00000         5.56723e-11         1.00000        550.064     237.902     0.915081     2.20335e-11     7.43040e-13
  120.000     4.10200e-09        0.00000         7.54872e-11         1.00000        550.064     237.902     0.914414     2.98539e-11     1.01409e-12
  122.500     5.56706e-09        0.00000         1.01876e-10         1.00000        550.063     237.902     0.913741     4.02605e-11     1.37761e-12
  125.000     7.52039e-09        0.00000         1.36858e-10         1.00000        550.063     237.902     0.913063     5.40453e-11     1.86294e-12
  127.500     1.01130e-08        0.00000         1.83028e-10         1.00000        550.062     237.902     0.912380     7.22236e-11     2.50803e-12
  130.000     1.35389e-08        0.00000         2.43695e-10         1.00000        550.062     237.902     0.911691     9.60907e-11     3.36178e-12
  132.500     1.80464e-08        0.00000         3.23071e-10         1.00000        550.061     237.902     0.910996     1.27293e-10     4.48690e-12
  135.000     2.39518e-08        0.00000         4.26492e-10         1.00000        550.060     237.902     0.910296     1.67912e-10     5.96349e-12
  137.500     3.16564e-08        0.00000         5.60685e-10         1.00000        550.059     237.902     0.909590     2.20574e-10     7.89346e-12
  140.000     4.16676e-08        0.00000         7.34107e-10         1.00000        550.058     237.902     0.908879     2.88573e-10     1.04060e-11
  142.500     5.46240e-08        0.00000         9.57340e-10         1.00000        550.057     237.902     0.908161     3.76028e-10     1.36641e-11
  145.000     7.13264e-08        0.00000         1.24358e-09         1.00000        550.055     237.902     0.907438     4.88071e-10     1.78728e-11
  147.500     9.27751e-08        0.00000         1.60921e-09         1.00000        550.054     237.902     0.906709     6.31066e-10     2.32892e-11
  150.000     1.20215e-07        0.00000         2.07453e-09         1.00000        550.052     237.902     0.905974     8.12886e-10     3.02341e-11
  152.500     1.55191e-07        0.00000         2.66453e-09         1.00000        550.050     237.902     0.905233     1.04322e-09     3.91066e-11
  155.000     1.99609e-07        0.00000         3.40997e-09         1.00000        550.048     237.902     0.904486     1.33398e-09     5.04016e-11
  157.500     2.55821e-07        0.00000         4.34847e-09         1.00000        550.046     237.902     0.903733     1.69971e-09     6.47305e-11
  160.000     3.26707e-07        0.00000         5.52596e-09         1.00000        550.044     237.902     0.902973     2.15816e-09     8.28464e-11
  162.500     4.15793e-07        0.00000         6.99833e-09         1.00000        550.041     237.902     0.902208     2.73089e-09     1.05674e-10
  165.000     5.27377e-07        0.00000         8.83328e-09         1.00000        550.039     237.902     0.901436     3.44399e-09     1.34343e-10
  167.500     6.66678e-07        0.00000         1.11127e-08         1.00000        550.036     237.902     0.900658     4.32899e-09     1.70233e-10
  170.000     8.40020e-07        0.00000         1.39351e-08         1.00000        550.032     237.902     0.899873     5.42379e-09     2.15021e-10
  172.500     1.05504e-06        0.00000         1.74191e-08         1.00000        550.029     237.902     0.899082     6.77388e-09     2.70739e-10
  175.000     1.32091e-06        0.00000         2.17062e-08         1.00000        550.025     237.902     0.898285     8.43363e-09     3.39844e-10
  177.500     1.64867e-06        0.00000         2.69659e-08         1.00000        550.021     237.902     0.897481     1.04679e-08     4.25297e-10
  180.000     2.05151e-06        0.00000         3.33994e-08         1.00000        550.016     237.902     0.896670     1.29537e-08     5.30653e-10
  182.500     2.54515e-06        0.00000         4.12460e-08         1.00000        550.011     237.902     0.895853     1.59825e-08     6.60174e-10
  185.000     3.14831e-06        0.00000         5.07886e-08         1.00000        550.005     237.902     0.895029     1.96623e-08     8.18953e-10
  187.500     3.88320e-06        0.00000         6.23610e-08         1.00000        550.000     237.902     0.894198     2.41203e-08     1.01306e-09
  190.000     4.77606e-06        0.00000         7.63564e-08         1.00000        549.993     237.902     0.893360     2.95062e-08     1.24970e-09
  192.500     5.85789e-06        0.00000         9.32361e-08         1.00000        549.986     237.902     0.892515     3.59953e-08     1.53743e-09
  195.000     7.16513e-06        0.00000         1.13540e-07         1.00000        549.979     237.902     0.891663     4.37929e-08     1.88635e-09
  197.500     8.74054e-06        0.00000         1.37900e-07         1.00000        549.971     237.902     0.890804     5.31380e-08     2.30838e-09
  200.000     1.06342e-05        0.00000         1.67049e-07         1.00000        549.963     237.902     0.889938     6.43088e-08     2.81755e-09
  202.500     1.29045e-05        0.00000         2.01843e-07         1.00000        549.953     237.902     0.889065     7.76283e-08     3.43031e-09
  205.000     1.56196e-05        0.00000         2.43270e-07         1.00000        549.944     237.902     0.888184     9.34699e-08     4.16593e-09
  207.500     1.88586e-05        0.00000         2.92474e-07         1.00000        549.933     237.902     0.887295     1.12265e-07     5.04692e-09
  210.000     2.27130e-05        0.00000         3.50776e-07         1.00000        549.922     237.902     0.886400     1.34511e-07     6.09949e-09
  212.500     2.72889e-05        0.00000         4.19694e-07         1.00000        549.909     237.902     0.885496     1.60779e-07     7.35414e-09
  215.000     3.27085e-05        0.00000         5.00972e-07         1.00000        549.896     237.902     0.884585     1.91722e-07     8.84624e-09
  217.500     3.91124e-05        0.00000         5.96610e-07         1.00000        549.883     237.902     0.883667     2.28092e-07     1.06167e-08
  220.000     4.66624e-05        0.00000         7.08890e-07         1.00000        549.868     237.902     0.882740     2.70741e-07     1.27129e-08
  222.500     5.55433e-05        0.00000         8.40418e-07         0.99999        549.852     237.902     0.881806     3.20644e-07     1.51893e-08
  225.000     6.59670e-05        0.00000         9.94160e-07         0.99999        549.835     237.902     0.880863     3.78908e-07     1.81087e-08
  227.500     7.81748e-05        0.00000         1.17348e-06         0.99999        549.817     237.902     0.879913     4.46787e-07     2.15429e-08
  230.000     9.24417e-05        0.00000         1.38221e-06         0.99999        549.798     237.902     0.878954     5.25701e-07     2.55745e-08
  232.500     1.09080e-04        0.00000         1.62465e-06         0.99999        549.777     237.902     0.877987     6.17253e-07     3.02978e-08
  235.000     1.28443e-04        0.00000         1.90568e-06         0.99999        549.755     237.902     0.877011     7.23251e-07     3.58203e-08
  237.500     1.50933e-04        0.00000         2.23080e-06         0.99999        549.732     237.902     0.876027     8.45728e-07     4.22647e-08
  240.000     1.77001e-04        0.00000         2.60617e-06         0.99998        549.708     237.902     0.875035     9.86965e-07     4.97703e-08
  242.500     2.07157e-04        0.00000         3.03874e-06         0.99998        549.682     237.902     0.874033     1.14952e-06     5.84951e-08
  245.000     2.41974e-04        0.00000         3.53625e-06         0.99998        549.654     237.902     0.873023     1.33625e-06     6.86184e-08
  247.500     2.82098e-04        0.00000         4.10741e-06         0.99998        549.625     237.902     0.872004     1.55035e-06     8.03425e-08
  250.000     3.28249e-04        0.00000         4.76188e-06         0.99997        549.594     237.902     0.870976     1.79537e-06     9.38963e-08
  252.500     3.81235e-04        0.00000         5.51047e-06         0.99997        549.561     237.902     0.869939     2.07527e-06     1.09537e-07
  255.000     4.41957e-04        0.00000         6.36518e-06         0.99996        549.526     237.902     0.868893     2.39443e-06     1.27555e-07
  257.500     5.11420e-04        0.00000         7.33933e-06         0.99996        549.489     237.902     0.867837     2.75773e-06     1.48275e-07
  260.000     5.90742e-04        0.00000         8.44769e-06         0.99995        549.450     237.902     0.866771     3.17054e-06     1.72063e-07
  262.500     6.81165e-04        0.00000         9.70661e-06         0.99995        549.409     237.902     0.865696     3.63880e-06     1.99326e-07
  265.000     7.84066e-04        0.00000         1.11341e-05         0.99994        549.366     237.902     0.864612     4.16908e-06     2.30522e-07
  267.500     9.00969e-04        0.00000         1.27501e-05         0.99993        549.321     237.902     0.863517     4.76857e-06     2.66160e-07
  270.000     1.03356e-03        0.00000         1.45765e-05         0.99992        549.272     237.902     0.862413     5.44520e-06     3.06809e-07
  272.500     1.18370e-03        0.00000         1.66375e-05         0.99991        549.222     237.902     0.861298     6.20767e-06     3.53099e-07
  275.000     1.35343e-03        0.00000         1.89593e-05         0.99990        549.168     237.902     0.860173     7.06551e-06     4.05734e-07
  277.500     1.54501e-03        0.00000         2.15710e-05         0.99989        549.112     237.902     0.859038     8.02912e-06     4.65492e-07
  280.000     1.76091e-03        0.00000         2.45043e-05         0.99988        549.053     237.902     0.857892     9.10989e-06     5.33236e-07
  282.500     2.00385e-03        0.00000         2.77938e-05         0.99986        548.991     237.902     0.856735     1.03202e-05     6.09922e-07
  285.000     2.27679e-03        0.00000         3.14773e-05         0.99984        548.926     237.902     0.855567     1.16736e-05     6.96604e-07
  287.500     2.58298e-03        0.00000         3.55958e-05         0.99982        548.857     237.902     0.854389     1.31847e-05     7.94447e-07
  290.000     2.92597e-03        0.00000         4.01943e-05         0.99980        548.785     237.902     0.853199     1.48695e-05     9.04734e-07
  292.500     3.30963e-03        0.00000         4.53212e-05         0.99978        548.710     237.902     0.851998     1.67452e-05     1.02888e-06
  295.000     3.73815e-03        0.00000         5.10293e-05         0.99976        548.631     237.902     0.850785     1.88306e-05     1.16843e-06
  297.500     4.21611e-03        0.00000         5.73757e-05         0.99973        548.548     237.902     0.849560     2.11458e-05     1.32510e-06
  300.000     4.74848e-03        0.00000         6.44223e-05         0.99970        548.461     237.902     0.848324     2.37127e-05     1.50075e-06
  302.500     5.34064e-03        0.00000         7.22357e-05         0.99967        548.370     237.902     0.847076     2.65549e-05     1.69743e-06
  305.000     5.99842e-03        0.00000         8.08881e-05         0.99963        548.275     237.902     0.845815     2.96976e-05     1.91739e-06
  307.500     6.72811e-03        0.00000         9.04570e-05         0.99959        548.175     237.902     0.844542     3.31681e-05     2.16307e-06
  310.000     7.53652e-03        0.00000         1.01026e-04         0.99955        548.071     237.902     0.843256     3.69957e-05     2.43714e-06
  312.500     8.43098e-03        0.00000         1.12685e-04         0.99950        547.962     237.902     0.841957     4.12117e-05     2.74252e-06
  315.000     9.41941e-03        0.00000         1.25530e-04         0.99945        547.848     237.902     0.840646     4.58499e-05     3.08240e-06
  317.500     1.05103e-02        0.00000         1.39665e-04         0.99940        547.729     237.902     0.839321     5.09462e-05     3.46022e-06
  320.000     1.17128e-02        0.00000         1.55201e-04         0.99934        547.604     237.902     0.837982     5.65390e-05     3.87975e-06
  322.500     1.30367e-02        0.00000         1.72255e-04         0.99927        547.475     237.902     0.836630     6.26696e-05     4.34508e-06
  325.000     1.44925e-02        0.00000         1.90955e-04         0.99920        547.339     237.902     0.835264     6.93817e-05     4.86063e-06
  327.500     1.60915e-02        0.00000         2.11436e-04         0.99912        547.198     237.902     0.833884     7.67219e-05     5.43121e-06
  330.000     1.78457e-02        0.00000         2.33842e-04         0.99904        547.051     237.902     0.832489     8.47401e-05     6.06204e-06
  332.500     1.97679e-02        0.00000         2.58327e-04         0.99895        546.898     237.902     0.831080     9.34889e-05     6.75875e-06
  335.000     2.18720e-02        0.00000         2.85053e-04         0.99885        546.738     237.902     0.829655     1.03025e-04     7.52744e-06
  337.500     2.41726e-02        0.00000         3.14196e-04         0.99875        546.572     237.902     0.828216     1.13407e-04     8.37470e-06
  340.000     2.66852e-02        0.00000         3.45939e-04         0.99864        546.399     237.902     0.826761     1.24698e-04     9.30766e-06
  342.500     2.94264e-02        0.00000         3.80478e-04         0.99852        546.218     237.902     0.825290     1.36966e-04     1.03340e-05
  345.000     3.24140e-02        0.00000         4.18020e-04         0.99839        546.031     237.902     0.823804     1.50280e-04     1.14620e-05
  347.500     3.56665e-02        0.00000         4.58787e-04         0.99825        545.836     237.902     0.822301     1.64717e-04     1.27006e-05
  350.000     3.92039e-02        0.00000         5.03009e-04         0.99810        545.633     237.902     0.820781     1.80354e-04     1.40594e-05
  352.500     4.30473e-02        0.00000         5.50934e-04         0.99794        545.422     237.902     0.819245     1.97275e-04     1.55488e-05
  355.000     4.72189e-02        0.00000         6.02820e-04         0.99777        545.204     237.902     0.817691     2.15568e-04     1.71799e-05
  357.500     5.17424e-02        0.00000         6.58942e-04         0.99759        544.976     237.902     0.816120     2.35326e-04     1.89646e-05
  360.000     5.66427e-02        0.00000         7.19589e-04         0.99740        544.740     237.902     0.814531     2.56645e-04     2.09160e-05
  362.500     6.19461e-02        0.00000         7.85066e-04         0.99719        544.495     237.902     0.812923     2.79629e-04     2.30478e-05
  365.000     6.76807e-02        0.00000         8.55694e-04         0.99697        544.241     237.902     0.811297     3.04386e-04     2.53748e-05
  367.500     7.38755e-02        0.00000         9.31809e-04         0.99674        543.977     237.902     0.809653     3.31028e-04     2.79129e-05
  370.000     8.05617e-02        0.00000         1.01377e-03         0.99649        543.703     237.902     0.807988     3.59675e-04     3.06794e-05
  372.500     8.77718e-02        0.00000         1.10194e-03         0.99622        543.419     237.902     0.806304     3.90452e-04     3.36925e-05
  375.000     9.55401e-02        0.00000         1.19673e-03         0.99594        543.125     237.902     0.804600     4.23489e-04     3.69719e-05
  377.500     1.03903e-01        0.00000         1.29853e-03         0.99564        542.820     237.902     0.802876     4.58925e-04     4.05386e-05
  380.000     1.12897e-01        0.00000         1.40778e-03         0.99532        542.503     237.902     0.801131     4.96904e-04     4.44153e-05
  382.500     1.22564e-01        0.00000         1.52494e-03         0.99498        542.176     237.902     0.799364     5.37575e-04     4.86261e-05
  385.000     1.32944e-01        0.00000         1.65047e-03         0.99463        541.837     237.902     0.797575     5.81098e-04     5.31970e-05
  387.500     1.44082e-01        0.00000         1.78487e-03         0.99425        541.486     237.902     0.795764     6.27636e-04     5.81556e-05
  390.000     1.56024e-01        0.00000         1.92867e-03         0.99385        541.122     237.902     0.793930     6.77365e-04     6.35318e-05
  392.500     1.68817e-01        0.00000         2.08240e-03         0.99343        540.746     237.902     0.792074     7.30463e-04     6.93573e-05
  395.000     1.82513e-01        0.00000         2.24663e-03         0.99298        540.356     237.902     0.790193     7.87122e-04     7.56663e-05
  397.500     1.97164e-01        0.00000         2.42197e-03         0.99251        539.953     237.902     0.788288     8.47537e-04     8.24951e-05
  400.000     2.12825e-01        0.00000         2.60902e-03         0.99202        539.536     237.902     0.786358     9.11917e-04     8.98828e-05
  402.500     2.29555e-01        0.00000         2.80844e-03         0.99150        539.105     237.902     0.784403     9.80476e-04     9.78713e-05
  405.000     2.47414e-01        0.00000         3.02091e-03         0.99095        538.659     237.902     0.782422     1.05344e-03     1.06505e-04
  407.500     2.66465e-01        0.00000         3.24712e-03         0.99037        538.198     237.902     0.780414     1.13105e-03     1.15833e-04
  410.000     2.86775e-01        0.00000         3.48784e-03         0.98977        537.721     237.902     0.778380     1.21355e-03     1.25905e-04
  412.500     3.08412e-01        0.00000         3.74381e-03         0.98913        537.228     237.902     0.776317     1.30119e-03     1.36777e-04
  415.000     3.31449e-01        0.00000         4.01586e-03         0.98846        536.719     237.902     0.774226     1.39424e-03     1.48508e-04
  417.500     3.55961e-01        0.00000         4.30482e-03         0.98776        536.193     237.902     0.772106     1.49300e-03     1.61161e-04
  420.000     3.82028e-01        0.00000         4.61156e-03         0.98702        535.649     237.902     0.769956     1.59774e-03     1.74804e-04
  422.500     4.09731e-01        0.00000         4.93701e-03         0.98625        535.087     237.902     0.767775     1.70878e-03     1.89510e-04
  425.000     4.39156e-01        0.00000         5.28212e-03         0.98544        534.507     237.902     0.765563     1.82644e-03     2.05355e-04
  427.500     4.70393e-01        0.00000         5.64788e-03         0.98459        533.907     237.902     0.763319     1.95105e-03     2.22425e-04
  430.000     5.03536e-01        0.00000         6.03533e-03         0.98370        533.288     237.902     0.761042     2.08297e-03     2.40809e-04
  432.500     5.38682e-01        0.00000         6.44557e-03         0.98278        532.648     237.902     0.758731     2.22256e-03     2.60603e-04
  435.000     5.75933e-01        0.00000         6.87972e-03         0.98181        531.987     237.902     0.756386     2.37021e-03     2.81911e-04
  437.500     6.15397e-01        0.00000         7.33897e-03         0.98079        531.305     237.902     0.754005     2.52631e-03     3.04845e-04
  440.000     6.57183e-01        0.00000         7.82455e-03         0.97973        530.600     237.902     0.751587     2.69131e-03     3.29525e-04
  442.500     7.01409e-01        0.00000         8.33777e-03         0.97862        529.873     237.902     0.749131     2.86562e-03     3.56081e-04
  445.000     7.48195e-01        0.00000         8.87996e-03         0.97747        529.121     237.902     0.746637     3.04973e-03     3.84651e-04
  447.500     7.97668e-01        0.00000         9.45254e-03         0.97626        528.345     237.902     0.744103     3.24411e-03     4.15386e-04
  450.000     8.49962e-01        0.00000         1.00570e-02         0.97500        527.544     237.902     0.741529     3.44928e-03     4.48448e-04
  452.500     9.05214e-01        0.00000         1.06948e-02         0.97369        526.717     237.902     0.738912     3.66578e-03     4.84013e-04
  455.000     9.63570e-01        0.00000         1.13677e-02         0.97233        525.862     237.902     0.736252     3.89417e-03     5.22270e-04
  457.500     1.02518e+00        0.00000         1.20773e-02         0.97090        524.980     237.902     0.733547     4.13504e-03     5.63424e-04
  460.000     1.09020e+00        0.00000         1.28254e-02         0.96942        524.068     237.902     0.730796     4.38903e-03     6.07697e-04
  462.500     1.15881e+00        0.00000         1.36139e-02         0.96787        523.127     237.902     0.727998     4.65679e-03     6.55330e-04
  465.000     1.23117e+00        0.00000         1.44447e-02         0.96626        522.155     237.902     0.725151     4.93902e-03     7.06584e-04
  467.500     1.30746e+00        0.00000         1.53199e-02         0.96459        521.151     237.902     0.722254     5.23647e-03     7.61743e-04
  470.000     1.38789e+00        0.00000         1.62416e-02         0.96285        520.113     237.902     0.719304     5.54990e-03     8.21117e-04
  472.500     1.47265e+00        0.00000         1.72122e-02         0.96103        519.041     237.902     0.716300     5.88016e-03     8.85043e-04
  475.000     1.56195e+00        0.00000         1.82339e-02         0.95915        517.933     237.902     0.713241     6.22810e-03     9.53887e-04
  477.500     1.65601e+00        0.00000         1.93094e-02         0.95719        516.788     237.902     0.710124     6.59467e-03     1.02805e-03
  480.000     1.75508e+00        0.00000         2.04414e-02         0.95515        515.604     237.902     0.706947     6.98085e-03     1.10798e-03
  482.500     1.85939e+00        0.00000         2.16325e-02         0.95303        514.380     237.902     0.703708     7.38769e-03     1.19414e-03
  485.000     1.96922e+00        0.00000         2.28860e-02         0.95082        513.114     237.902     0.700404     7.81632e-03     1.28708e-03
  487.500     2.08483e+00        0.00000         2.42048e-02         0.94853        511.805     237.902     0.697034     8.26794e-03     1.38736e-03
  490.000     2.20652e+00        0.00000         2.55924e-02         0.94615        510.450     237.902     0.693594     8.74383e-03     1.49564e-03
  492.500     2.33460e+00        0.00000         2.70524e-02         0.94367        509.047     237.902     0.690083     9.24537e-03     1.61261e-03
  495.000     2.46940e+00        0.00000         2.85885e-02         0.94110        507.596     237.902     0.686496     9.77403e-03     1.73907e-03
  497.500     2.61127e+00        0.00000         3.02049e-02         0.93843        506.092     237.902     0.682830     1.03314e-02     1.87587e-03
  500.000     2.76059e+00        0.00000         3.19059e-02         0.93564        504.534     237.902     0.679083     1.09192e-02     2.02398e-03
  502.500     2.91774e+00        0.00000         3.36962e-02         0.93275        502.920     237.902     0.675250     1.15393e-02     2.18447e-03
  505.000     3.08317e+00        0.00000         3.55808e-02         0.92975        501.245     237.902     0.671328     1.21937e-02     2.35854e-03
  507.500     3.25733e+00        0.00000         3.75651e-02         0.92662        499.508     237.902     0.667312     1.28845e-02     2.54754e-03
  510.000     3.44070e+00        0.00000         3.96549e-02         0.92336        497.706     237.902     0.663198     1.36142e-02     2.75297e-03
  512.500     3.63382e+00        0.00000         4.18566e-02         0.91998        495.833     237.902     0.658980     1.43854e-02     2.97653e-03
  515.000     3.83727e+00        0.00000         4.41770e-02         0.91645        493.888     237.902     0.654653     1.52008e-02     3.22015e-03
  517.500     4.05166e+00        0.00000         4.66235e-02         0.91278        491.864     237.902     0.650212     1.60637e-02     3.48600e-03
  520.000     4.27767e+00        0.00000         4.92044e-02         0.90896        489.759     237.902     0.645649     1.69774e-02     3.77658e-03
  522.500     4.51604e+00        0.00000         5.19286e-02         0.90498        487.566     237.902     0.640957     1.79458e-02     4.09472e-03
  525.000     4.76759e+00        0.00000         5.48059e-02         0.90082        485.280     237.902     0.636129     1.89732e-02     4.44370e-03
  527.500     5.03319e+00        0.00000         5.78473e-02         0.89648        482.895     237.902     0.631155     2.00643e-02     4.82729e-03
  530.000     5.31385e+00        0.00000         6.10649e-02         0.89195        480.403     237.902     0.626026     2.12245e-02     5.24990e-03
  532.500     5.61065e+00        0.00000         6.44723e-02         0.88721        477.798     237.902     0.620731     2.24597e-02     5.71664e-03
  535.000     5.92482e+00        0.00000         6.80848e-02         0.88225        475.070     237.902     0.615256     2.37769e-02     6.23356e-03
  537.500     6.25776e+00        0.00000         7.19197e-02         0.87705        472.208     237.902     0.609589     2.51839e-02     6.80781e-03
  540.000     6.61102e+00        0.00000         7.59967e-02         0.87160        469.203     237.902     0.603712     2.66898e-02     7.44793e-03
  542.500     6.98641e+00        0.00000         8.03384e-02         0.86587        466.040     237.902     0.597608     2.83049e-02     8.16420e-03
  545.000     7.38599e+00        0.00000         8.49712e-02         0.85983        462.705     237.902     0.591254     3.00418e-02     8.96916e-03
  547.500     7.81218e+00        0.00000         8.99259e-02         0.85347        459.178     237.902     0.584624     3.19148e-02     9.87822e-03
  550.000     8.26784e+00        0.00000         9.52393e-02         0.84673        455.440     237.902     0.577689     3.39416e-02     1.09106e-02
  552.500     8.75636e+00        0.00000         1.00955e-01         0.83958        451.464     237.902     0.570411     3.61433e-02     1.20906e-02
  555.000     9.28190e+00        0.00000         1.07128e-01         0.83197        447.219     237.902     0.562745     3.85464e-02     1.34496e-02
  557.500     9.84959e+00        0.00000         1.13824e-01         0.82383        442.665     237.902     0.554636     4.11838e-02     1.50287e-02
  560.000     1.04660e+01        0.00000         1.21129e-01         0.81508        437.752     237.902     0.546010     4.40982e-02     1.68832e-02
  562.500     1.11395e+01        0.00000         1.29157e-01         0.80560        432.414     237.902     0.536772     4.73463e-02     1.90901e-02
  565.000     1.18817e+01        0.00000         1.38059e-01         0.79525        426.562     237.902     0.526794     5.10057e-02     2.17598e-02
  567.500     1.27089e+01        0.00000         1.48055e-01         0.78381        420.068     237.902     0.515889     5.51884e-02     2.50596e-02
  570.000     1.36457e+01        0.00000         1.59474e-01         0.77095        412.736     237.902     0.503776     6.00659e-02     2.92591e-02
  572.500     1.47326e+01        0.00000         1.72869e-01         0.75613        404.244     237.902     0.489983     6.59262e-02     3.48358e-02
  575.000     1.60469e+01        0.00000         1.89292e-01         0.73828        393.971     237.902     0.473605     7.33266e-02     4.27697e-02
  577.500     1.77817e+01        0.00000         2.11396e-01         0.71476        380.358     237.902     0.452359     8.36813e-02     5.57122e-02
  580.000     2.12491e+01        0.00000         2.57367e-01         0.66723        352.705     237.902     0.410524     1.06808e-01     9.38563e-02
  580.121     2.21871e+01        0.00000         2.70313e-01         0.65411        345.059     237.902     0.399215     1.13744e-01     1.08254e-01
  580.121     2.21971e+01        0.00000         2.70452e-01         0.65397        344.977     237.902     0.399094     1.13820e-01     1.08420e-01
  580.000     2.31221e+01        0.00000         2.83481e-01         0.64084        337.339     237.902     0.387892     1.21008e-01     1.25046e-01
  577.500     2.63985e+01        0.00000         3.32318e-01         0.59221        309.192     237.902     0.347271     1.49940e-01     2.13148e-01
  575.000     2.79374e+01        0.00000         3.57266e-01         0.56754        295.097     237.902     0.327229     1.66066e-01     2.80962e-01
  572.500     2.90510e+01        0.00000         3.76515e-01         0.54851        284.355     237.902     0.312043     1.79204e-01     3.49116e-01
  570.000     2.99323e+01        0.00000         3.92715e-01         0.53247        275.405     237.902     0.299430     1.90766e-01     4.20732e-01
  567.500     3.06588e+01        0.00000         4.06923e-01         0.51837        267.627     237.902     0.288485     2.01311e-01     4.97307e-01
  565.000     3.12712e+01        0.00000         4.19691e-01         0.50564        260.696     237.902     0.278737     2.11126e-01     5.79882e-01
  562.500     3.17941e+01        0.00000         4.31349e-01         0.49398        254.419     237.902     0.269903     2.20384e-01     6.69343e-01
  560.000     3.22439e+01        0.00000         4.42117e-01         0.48315        248.665     237.902     0.261799     2.29195e-01     7.66531e-01
  557.500     3.26321e+01        0.00000         4.52150e-01         0.47301        243.346     237.902     0.254293     2.37638e-01     8.72295e-01
  555.000     3.29673e+01        0.00000         4.61560e-01         0.46346        238.395     237.902     0.247292     2.45769e-01     9.87517e-01
  554.947     3.29738e+01        0.00000         4.61752e-01         0.46326        238.294     237.902     0.247149     2.45938e-01     9.90051e-01
  554.741     3.29991e+01        0.50000         4.62500e-01         0.46250        237.902     237.902     0.246594     2.46594e-01     1.00000e+00
END

$Env_BP << END
#    Temp         Sat Pres                                                                                      Liq Den       Gas Den             
#    (C)           (bar)         Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#-----------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   554.7414     3.29991e+01         0.5000          4.62500e-01       4.62500e-01      237.902     237.902     0.246594     2.46594e-01     1.00000e+00
   554.5355     3.30243e+01         1.0000          4.61740e-01       4.63248e-01      237.902     237.511     0.247250     2.46039e-01     9.90050e-01
   552.5000     3.32562e+01         1.0000          4.54399e-01       4.70434e-01      237.902     233.761     0.253632     2.40722e-01     8.98361e-01
   550.0000     3.35039e+01         1.0000          4.45770e-01       4.78841e-01      237.902     229.405     0.261258     2.34527e-01     7.99893e-01
   547.5000     3.37147e+01         1.0000          4.37521e-01       4.86835e-01      237.902     225.294     0.268675     2.28662e-01     7.14439e-01
   545.0000     3.38921e+01         1.0000          4.29609e-01       4.94461e-01      237.902     221.402     0.275903     2.23090e-01     6.39827e-01
   542.5000     3.40389e+01         1.0000          4.21998e-01       5.01757e-01      237.902     217.709     0.282960     2.17781e-01     5.74337e-01
   540.0000     3.41578e+01         1.0000          4.14660e-01       5.08754e-01      237.902     214.195     0.289862     2.12709e-01     5.16592e-01
   537.5000     3.42507e+01         1.0000          4.07569e-01       5.15479e-01      237.902     210.845     0.296619     2.07852e-01     4.65473e-01
   535.0000     3.43197e+01         1.0000          4.00704e-01       5.21957e-01      237.902     207.646     0.303244     2.03192e-01     4.20059e-01
   532.5000     3.43664e+01         1.0000          3.94047e-01       5.28207e-01      237.902     204.585     0.309744     1.98711e-01     3.79588e-01
   530.0000     3.43922e+01         1.0000          3.87582e-01       5.34248e-01      237.902     201.652     0.316129     1.94397e-01     3.43422e-01
   527.5000     3.43984e+01         1.0000          3.81294e-01       5.40096e-01      237.902     198.839     0.322404     1.90236e-01     3.11024e-01
   525.0000     3.43862e+01         1.0000          3.75171e-01       5.45764e-01      237.902     196.137     0.328575     1.86217e-01     2.81938e-01
   522.5000     3.43567e+01         1.0000          3.69201e-01       5.51267e-01      237.902     193.539     0.334650     1.82331e-01     2.55772e-01
   520.0000     3.43108e+01         1.0000          3.63376e-01       5.56616e-01      237.902     191.038     0.340631     1.78569e-01     2.32194e-01
   517.5000     3.42495e+01         1.0000          3.57686e-01       5.61822e-01      237.902     188.629     0.346524     1.74923e-01     2.10912e-01
   515.0000     3.41736e+01         1.0000          3.52122e-01       5.66893e-01      237.902     186.306     0.352332     1.71385e-01     1.91677e-01
   512.5000     3.40838e+01         1.0000          3.46679e-01       5.71840e-01      237.902     184.064     0.358060     1.67950e-01     1.74269e-01
   510.0000     3.39808e+01         1.0000          3.41349e-01       5.76669e-01      237.902     181.899     0.363709     1.64610e-01     1.58497e-01
   507.5000     3.38653e+01         1.0000          3.36126e-01       5.81390e-01      237.902     179.806     0.369284     1.61362e-01     1.44193e-01
   505.0000     3.37379e+01         1.0000          3.31005e-01       5.86008e-01      237.902     177.782     0.374786     1.58199e-01     1.31208e-01
   502.5000     3.35992e+01         1.0000          3.25981e-01       5.90531e-01      237.902     175.823     0.380219     1.55118e-01     1.19412e-01
   500.0000     3.34497e+01         1.0000          3.21050e-01       5.94964e-01      237.902     173.926     0.385585     1.52114e-01     1.08688e-01
   497.5000     3.32899e+01         1.0000          3.16206e-01       5.99314e-01      237.902     172.088     0.390885     1.49183e-01     9.89317e-02
   495.0000     3.31204e+01         1.0000          3.11447e-01       6.03584e-01      237.902     170.307     0.396123     1.46322e-01     9.00523e-02
   492.5000     3.29416e+01         1.0000          3.06769e-01       6.07781e-01      237.902     168.578     0.401298     1.43527e-01     8.19669e-02
   490.0000     3.27539e+01         1.0000          3.02168e-01       6.11909e-01      237.902     166.901     0.406414     1.40796e-01     7.46016e-02
   487.5000     3.25577e+01         1.0000          2.97641e-01       6.15972e-01      237.902     165.272     0.411472     1.38125e-01     6.78902e-02
   485.0000     3.23535e+01         1.0000          2.93186e-01       6.19974e-01      237.902     163.689     0.416473     1.35512e-01     6.17731e-02
   482.5000     3.21416e+01         1.0000          2.88800e-01       6.23919e-01      237.902     162.151     0.421419     1.32955e-01     5.61965e-02
   480.0000     3.19224e+01         1.0000          2.84480e-01       6.27812e-01      237.902     160.656     0.426311     1.30451e-01     5.11119e-02
   477.5000     3.16962e+01         1.0000          2.80224e-01       6.31654e-01      237.902     159.201     0.431150     1.27997e-01     4.64756e-02
   475.0000     3.14635e+01         1.0000          2.76031e-01       6.35451e-01      237.902     157.785     0.435938     1.25593e-01     4.22478e-02
   472.5000     3.12244e+01         1.0000          2.71897e-01       6.39203e-01      237.902     156.406     0.440675     1.23236e-01     3.83926e-02
   470.0000     3.09794e+01         1.0000          2.67822e-01       6.42915e-01      237.902     155.062     0.445363     1.20925e-01     3.48773e-02
   467.5000     3.07287e+01         1.0000          2.63803e-01       6.46590e-01      237.902     153.753     0.450003     1.18657e-01     3.16723e-02
   465.0000     3.04727e+01         1.0000          2.59840e-01       6.50228e-01      237.902     152.477     0.454595     1.16431e-01     2.87506e-02
   462.5000     3.02115e+01         1.0000          2.55929e-01       6.53834e-01      237.902     151.232     0.459140     1.14246e-01     2.60876e-02
   460.0000     2.99456e+01         1.0000          2.52071e-01       6.57409e-01      237.902     150.017     0.463640     1.12101e-01     2.36610e-02
   457.5000     2.96751e+01         1.0000          2.48264e-01       6.60956e-01      237.902     148.831     0.468095     1.09994e-01     2.14502e-02
   455.0000     2.94003e+01         1.0000          2.44505e-01       6.64476e-01      237.902     147.673     0.472506     1.07924e-01     1.94367e-02
   452.5000     2.91215e+01         1.0000          2.40796e-01       6.67971e-01      237.902     146.541     0.476873     1.05890e-01     1.76034e-02
   450.0000     2.88390e+01         1.0000          2.37133e-01       6.71443e-01      237.902     145.435     0.481198     1.03891e-01     1.59348e-02
   447.5000     2.85528e+01         1.0000          2.33516e-01       6.74893e-01      237.902     144.354     0.485481     1.01926e-01     1.44166e-02
   445.0000     2.82634e+01         1.0000          2.29945e-01       6.78324e-01      237.902     143.296     0.489722     9.99934e-02     1.30359e-02
   442.5000     2.79709e+01         1.0000          2.26418e-01       6.81735e-01      237.902     142.260     0.493923     9.80933e-02     1.17808e-02
   440.0000     2.76755e+01         1.0000          2.22934e-01       6.85130e-01      237.902     141.247     0.498084     9.62246e-02     1.06402e-02
   437.5000     2.73775e+01         1.0000          2.19493e-01       6.88508e-01      237.902     140.254     0.502205     9.43866e-02     9.60434e-03
   435.0000     2.70770e+01         1.0000          2.16094e-01       6.91871e-01      237.902     139.281     0.506288     9.25783e-02     8.66399e-03
   432.5000     2.67743e+01         1.0000          2.12736e-01       6.95221e-01      237.902     138.328     0.510331     9.07993e-02     7.81081e-03
   430.0000     2.64696e+01         1.0000          2.09419e-01       6.98557e-01      237.902     137.393     0.514337     8.90489e-02     7.03714e-03
   427.5000     2.61630e+01         1.0000          2.06141e-01       7.01880e-01      237.902     136.476     0.518306     8.73265e-02     6.33596e-03
   425.0000     2.58547e+01         1.0000          2.02902e-01       7.05192e-01      237.902     135.576     0.522238     8.56315e-02     5.70085e-03
   422.5000     2.55450e+01         1.0000          1.99703e-01       7.08493e-01      237.902     134.693     0.526133     8.39634e-02     5.12593e-03
   420.0000     2.52340e+01         1.0000          1.96541e-01       7.11783e-01      237.902     133.825     0.529992     8.23216e-02     4.60583e-03
   417.5000     2.49218e+01         1.0000          1.93417e-01       7.15063e-01      237.902     132.973     0.533816     8.07058e-02     4.13560e-03
   415.0000     2.46087e+01         1.0000          1.90329e-01       7.18334e-01      237.902     132.135     0.537605     7.91155e-02     3.71075e-03
   412.5000     2.42947e+01         1.0000          1.87279e-01       7.21595e-01      237.902     131.311     0.541359     7.75502e-02     3.32715e-03
   410.0000     2.39802e+01         1.0000          1.84264e-01       7.24847e-01      237.902     130.500     0.545079     7.60095e-02     2.98103e-03
   407.5000     2.36652e+01         1.0000          1.81286e-01       7.28090e-01      237.902     129.703     0.548765     7.44931e-02     2.66895e-03
   405.0000     2.33498e+01         1.0000          1.78342e-01       7.31325e-01      237.902     128.918     0.552417     7.30006e-02     2.38776e-03
   402.5000     2.30342e+01         1.0000          1.75434e-01       7.34551e-01      237.902     128.145     0.556036     7.15316e-02     2.13457e-03
   400.0000     2.27187e+01         1.0000          1.72560e-01       7.37768e-01      237.902     127.384     0.559623     7.00858e-02     1.90678e-03
   397.5000     2.24032e+01         1.0000          1.69720e-01       7.40977e-01      237.902     126.633     0.563177     6.86629e-02     1.70198e-03
   395.0000     2.20879e+01         1.0000          1.66914e-01       7.44177e-01      237.902     125.893     0.566699     6.72625e-02     1.51799e-03
   392.5000     2.17730e+01         1.0000          1.64141e-01       7.47369e-01      237.902     125.164     0.570189     6.58844e-02     1.35282e-03
   390.0000     2.14586e+01         1.0000          1.61402e-01       7.50551e-01      237.902     124.444     0.573648     6.45283e-02     1.20467e-03
   387.5000     2.11448e+01         1.0000          1.58696e-01       7.53725e-01      237.902     123.734     0.577076     6.31939e-02     1.07187e-03
   385.0000     2.08318e+01         1.0000          1.56021e-01       7.56889e-01      237.902     123.033     0.580473     6.18809e-02     9.52945e-04
   382.5000     2.05196e+01         1.0000          1.53380e-01       7.60044e-01      237.902     122.341     0.583839     6.05891e-02     8.46517e-04
   380.0000     2.02083e+01         1.0000          1.50770e-01       7.63189e-01      237.902     121.657     0.587176     5.93181e-02     7.51353e-04
   377.5000     1.98982e+01         1.0000          1.48191e-01       7.66324e-01      237.902     120.981     0.590482     5.80679e-02     6.66331e-04
   375.0000     1.95892e+01         1.0000          1.45645e-01       7.69448e-01      237.902     120.313     0.593759     5.68380e-02     5.90432e-04
   372.5000     1.92814e+01         1.0000          1.43129e-01       7.72562e-01      237.902     119.652     0.597007     5.56284e-02     5.22733e-04
   370.0000     1.89751e+01         1.0000          1.40644e-01       7.75665e-01      237.902     118.999     0.600226     5.44386e-02     4.62400e-04
   367.5000     1.86702e+01         1.0000          1.38190e-01       7.78756e-01      237.902     118.353     0.603416     5.32686e-02     4.08676e-04
   365.0000     1.83668e+01         1.0000          1.35766e-01       7.81836e-01      237.902     117.713     0.606578     5.21180e-02     3.60879e-04
   362.5000     1.80652e+01         1.0000          1.33372e-01       7.84903e-01      237.902     117.080     0.609712     5.09866e-02     3.18390e-04
   360.0000     1.77652e+01         1.0000          1.31008e-01       7.87958e-01      237.902     116.453     0.612817     4.98743e-02     2.80654e-04
   357.5000     1.74670e+01         1.0000          1.28673e-01       7.90999e-01      237.902     115.832     0.615895     4.87808e-02     2.47168e-04
   355.0000     1.71707e+01         1.0000          1.26368e-01       7.94028e-01      237.902     115.217     0.618946     4.77058e-02     2.17480e-04
   352.5000     1.68764e+01         1.0000          1.24092e-01       7.97042e-01      237.902     114.607     0.621970     4.66492e-02     1.91183e-04
   350.0000     1.65841e+01         1.0000          1.21845e-01       8.00042e-01      237.902     114.002     0.624966     4.56108e-02     1.67910e-04
   347.5000     1.62940e+01         1.0000          1.19627e-01       8.03027e-01      237.902     113.403     0.627937     4.45902e-02     1.47332e-04
   345.0000     1.60059e+01         1.0000          1.17437e-01       8.05997e-01      237.902     112.808     0.630880     4.35874e-02     1.29154e-04
   342.5000     1.57201e+01         1.0000          1.15275e-01       8.08952e-01      237.902     112.219     0.633798     4.26021e-02     1.13111e-04
   340.0000     1.54366e+01         1.0000          1.13142e-01       8.11890e-01      237.902     111.633     0.636690     4.16340e-02     9.89658e-05
   337.5000     1.51555e+01         1.0000          1.11036e-01       8.14813e-01      237.902     111.052     0.639556     4.06830e-02     8.65048e-05
   335.0000     1.48767e+01         1.0000          1.08958e-01       8.17718e-01      237.902     110.476     0.642397     3.97489e-02     7.55385e-05
   332.5000     1.46004e+01         1.0000          1.06907e-01       8.20606e-01      237.902     109.903     0.645212     3.88315e-02     6.58967e-05
   330.0000     1.43266e+01         1.0000          1.04883e-01       8.23477e-01      237.902     109.334     0.648003     3.79304e-02     5.74278e-05
   327.5000     1.40554e+01         1.0000          1.02887e-01       8.26330e-01      237.902     108.769     0.650769     3.70457e-02     4.99963e-05
   325.0000     1.37867e+01         1.0000          1.00917e-01       8.29164e-01      237.902     108.207     0.653510     3.61769e-02     4.34817e-05
   322.5000     1.35207e+01         1.0000          9.89732e-02       8.31979e-01      237.902     107.649     0.656228     3.53240e-02     3.77766e-05
   320.0000     1.32574e+01         1.0000          9.70562e-02       8.34776e-01      237.902     107.094     0.658921     3.44867e-02     3.27854e-05
   317.5000     1.29967e+01         1.0000          9.51654e-02       8.37553e-01      237.902     106.542     0.661590     3.36648e-02     2.84234e-05
   315.0000     1.27388e+01         1.0000          9.33004e-02       8.40310e-01      237.902     105.993     0.664236     3.28582e-02     2.46150e-05
   312.5000     1.24837e+01         1.0000          9.14613e-02       8.43047e-01      237.902     105.446     0.666858     3.20666e-02     2.12937e-05
   310.0000     1.22314e+01         1.0000          8.96477e-02       8.45764e-01      237.902     104.903     0.669458     3.12898e-02     1.84001e-05
   307.5000     1.19820e+01         1.0000          8.78594e-02       8.48459e-01      237.902     104.362     0.672034     3.05276e-02     1.58818e-05
   305.0000     1.17354e+01         1.0000          8.60963e-02       8.51134e-01      237.902     103.823     0.674587     2.97798e-02     1.36927e-05
   302.5000     1.14917e+01         1.0000          8.43582e-02       8.53787e-01      237.902     103.287     0.677118     2.90463e-02     1.17917e-05
   300.0000     1.12510e+01         1.0000          8.26448e-02       8.56419e-01      237.902     102.753     0.679627     2.83268e-02     1.01427e-05
   297.5000     1.10131e+01         1.0000          8.09560e-02       8.59028e-01      237.902     102.221     0.682113     2.76211e-02     8.71404e-06
   295.0000     1.07783e+01         1.0000          7.92916e-02       8.61615e-01      237.902     101.691     0.684578     2.69291e-02     7.47763e-06
   292.5000     1.05464e+01         1.0000          7.76514e-02       8.64180e-01      237.902     101.163     0.687020     2.62506e-02     6.40884e-06
   290.0000     1.03174e+01         1.0000          7.60352e-02       8.66722e-01      237.902     100.637     0.689442     2.55853e-02     5.48604e-06
   287.5000     1.00915e+01         1.0000          7.44428e-02       8.69241e-01      237.902     100.112     0.691842     2.49331e-02     4.69024e-06
   285.0000     9.86862e+00         1.0000          7.28740e-02       8.71736e-01      237.902      99.589     0.694220     2.42938e-02     4.00478e-06
   282.5000     9.64875e+00         1.0000          7.13287e-02       8.74208e-01      237.902      99.067     0.696578     2.36673e-02     3.41510e-06
   280.0000     9.43191e+00         1.0000          6.98066e-02       8.76657e-01      237.902      98.546     0.698915     2.30532e-02     2.90844e-06
   277.5000     9.21811e+00         1.0000          6.83076e-02       8.79081e-01      237.902      98.027     0.701232     2.24516e-02     2.47366e-06
   275.0000     9.00736e+00         1.0000          6.68315e-02       8.81482e-01      237.902      97.508     0.703528     2.18621e-02     2.10104e-06
   272.5000     8.79966e+00         1.0000          6.53780e-02       8.83857e-01      237.902      96.991     0.705804     2.12846e-02     1.78211e-06
   270.0000     8.59501e+00         1.0000          6.39471e-02       8.86209e-01      237.902      96.474     0.708060     2.07189e-02     1.50950e-06
   267.5000     8.39342e+00         1.0000          6.25385e-02       8.88536e-01      237.902      95.958     0.710296     2.01649e-02     1.27678e-06
   265.0000     8.19488e+00         1.0000          6.11521e-02       8.90837e-01      237.902      95.443     0.712512     1.96223e-02     1.07840e-06
   262.5000     7.99940e+00         1.0000          5.97876e-02       8.93114e-01      237.902      94.928     0.714709     1.90911e-02     9.09515e-07
   260.0000     7.80697e+00         1.0000          5.84449e-02       8.95366e-01      237.902      94.414     0.716887     1.85710e-02     7.65945e-07
   257.5000     7.61758e+00         1.0000          5.71238e-02       8.97592e-01      237.902      93.900     0.719045     1.80619e-02     6.44070e-07
   255.0000     7.43124e+00         1.0000          5.58241e-02       8.99793e-01      237.902      93.387     0.721185     1.75636e-02     5.40761e-07
   252.5000     7.24794e+00         1.0000          5.45457e-02       9.01968e-01      237.902      92.874     0.723306     1.70760e-02     4.53318e-07
   250.0000     7.06766e+00         1.0000          5.32883e-02       9.04117e-01      237.902      92.360     0.725408     1.65988e-02     3.79416e-07
   247.5000     6.89041e+00         1.0000          5.20517e-02       9.06241e-01      237.902      91.847     0.727492     1.61319e-02     3.17054e-07
   245.0000     6.71616e+00         1.0000          5.08359e-02       9.08338e-01      237.902      91.334     0.729558     1.56753e-02     2.64509e-07
   242.5000     6.54492e+00         1.0000          4.96406e-02       9.10409e-01      237.902      90.820     0.731605     1.52286e-02     2.20308e-07
   240.0000     6.37666e+00         1.0000          4.84655e-02       9.12455e-01      237.902      90.306     0.733635     1.47918e-02     1.83183e-07
   237.5000     6.21138e+00         1.0000          4.73107e-02       9.14474e-01      237.902      89.792     0.735647     1.43647e-02     1.52054e-07
   235.0000     6.04905e+00         1.0000          4.61758e-02       9.16466e-01      237.902      89.277     0.737642     1.39471e-02     1.25994e-07
   232.5000     5.88968e+00         1.0000          4.50607e-02       9.18432e-01      237.902      88.762     0.739619     1.35390e-02     1.04216e-07
   230.0000     5.73323e+00         1.0000          4.39652e-02       9.20372e-01      237.902      88.246     0.741578     1.31401e-02     8.60466e-08
   227.5000     5.57970e+00         1.0000          4.28892e-02       9.22285e-01      237.902      87.729     0.743521     1.27503e-02     7.09145e-08
   225.0000     5.42906e+00         1.0000          4.18324e-02       9.24171e-01      237.902      87.211     0.745447     1.23694e-02     5.83344e-08
   222.5000     5.28130e+00         1.0000          4.07946e-02       9.26031e-01      237.902      86.693     0.747356     1.19974e-02     4.78948e-08
   220.0000     5.13640e+00         1.0000          3.97757e-02       9.27863e-01      237.902      86.173     0.749248     1.16341e-02     3.92473e-08
   217.5000     4.99433e+00         1.0000          3.87756e-02       9.29669e-01      237.902      85.652     0.751124     1.12793e-02     3.20979e-08
   215.0000     4.85508e+00         1.0000          3.77939e-02       9.31449e-01      237.902      85.131     0.752983     1.09329e-02     2.61981e-08
   212.5000     4.71863e+00         1.0000          3.68306e-02       9.33201e-01      237.902      84.608     0.754827     1.05948e-02     2.13392e-08
   210.0000     4.58495e+00         1.0000          3.58855e-02       9.34927e-01      237.902      84.083     0.756654     1.02648e-02     1.73453e-08
   207.5000     4.45401e+00         1.0000          3.49583e-02       9.36625e-01      237.902      83.557     0.758466     9.94277e-03     1.40690e-08
   205.0000     4.32580e+00         1.0000          3.40490e-02       9.38297e-01      237.902      83.030     0.760262     9.62861e-03     1.13870e-08
   202.5000     4.20030e+00         1.0000          3.31572e-02       9.39942e-01      237.902      82.501     0.762042     9.32218e-03     9.19601e-09
   200.0000     4.07746e+00         1.0000          3.22829e-02       9.41560e-01      237.902      81.971     0.763807     9.02334e-03     7.40999e-09
   197.5000     3.95728e+00         1.0000          3.14258e-02       9.43151e-01      237.902      81.438     0.765556     8.73196e-03     5.95723e-09
   195.0000     3.83972e+00         1.0000          3.05857e-02       9.44715e-01      237.902      80.904     0.767291     8.44793e-03     4.77817e-09
   192.5000     3.72475e+00         1.0000          2.97626e-02       9.46253e-01      237.902      80.368     0.769010     8.17111e-03     3.82340e-09
   190.0000     3.61236e+00         1.0000          2.89561e-02       9.47763e-01      237.902      79.830     0.770715     7.90137e-03     3.05204e-09
   187.5000     3.50250e+00         1.0000          2.81661e-02       9.49247e-01      237.902      79.290     0.772404     7.63860e-03     2.43030e-09
   185.0000     3.39516e+00         1.0000          2.73925e-02       9.50705e-01      237.902      78.748     0.774080     7.38266e-03     1.93037e-09
   182.5000     3.29030e+00         1.0000          2.66349e-02       9.52135e-01      237.902      78.204     0.775740     7.13345e-03     1.52937e-09
   180.0000     3.18789e+00         1.0000          2.58933e-02       9.53540e-01      237.902      77.657     0.777387     6.89083e-03     1.20851e-09
   177.5000     3.08790e+00         1.0000          2.51675e-02       9.54917e-01      237.902      77.109     0.779019     6.65469e-03     9.52432e-10
   175.0000     2.99031e+00         1.0000          2.44573e-02       9.56269e-01      237.902      76.558     0.780637     6.42490e-03     7.48583e-10
   172.5000     2.89508e+00         1.0000          2.37624e-02       9.57593e-01      237.902      76.004     0.782242     6.20136e-03     5.86739e-10
   170.0000     2.80218e+00         1.0000          2.30827e-02       9.58892e-01      237.902      75.448     0.783832     5.98395e-03     4.58591e-10
   167.5000     2.71158e+00         1.0000          2.24180e-02       9.60165e-01      237.902      74.889     0.785409     5.77255e-03     3.57401e-10
   165.0000     2.62324e+00         1.0000          2.17681e-02       9.61412e-01      237.902      74.328     0.786972     5.56705e-03     2.77723e-10
   162.5000     2.53714e+00         1.0000          2.11328e-02       9.62632e-01      237.902      73.764     0.788522     5.36734e-03     2.15163e-10
   160.0000     2.45325e+00         1.0000          2.05120e-02       9.63827e-01      237.902      73.198     0.790059     5.17330e-03     1.66187e-10
   157.5000     2.37152e+00         1.0000          1.99054e-02       9.64997e-01      237.902      72.629     0.791582     4.98482e-03     1.27959e-10
   155.0000     2.29193e+00         1.0000          1.93128e-02       9.66141e-01      237.902      72.057     0.793092     4.80180e-03     9.82117e-11
   152.5000     2.21444e+00         1.0000          1.87341e-02       9.67259e-01      237.902      71.482     0.794590     4.62412e-03     7.51355e-11
   150.0000     2.13903e+00         1.0000          1.81691e-02       9.68353e-01      237.902      70.904     0.796074     4.45168e-03     5.72910e-11
   147.5000     2.06565e+00         1.0000          1.76175e-02       9.69421e-01      237.902      70.323     0.797546     4.28438e-03     4.35369e-11
   145.0000     1.99427e+00         1.0000          1.70792e-02       9.70465e-01      237.902      69.740     0.799006     4.12210e-03     3.29707e-11
   142.5000     1.92487e+00         1.0000          1.65540e-02       9.71484e-01      237.902      69.153     0.800453     3.96474e-03     2.48808e-11
   140.0000     1.85740e+00         1.0000          1.60416e-02       9.72479e-01      237.902      68.564     0.801887     3.81221e-03     1.87084e-11
   137.5000     1.79183e+00         1.0000          1.55420e-02       9.73449e-01      237.902      67.971     0.803309     3.66439e-03     1.40155e-11
   135.0000     1.72813e+00         1.0000          1.50548e-02       9.74396e-01      237.902      67.376     0.804719     3.52118e-03     1.04604e-11
   132.5000     1.66626e+00         1.0000          1.45800e-02       9.75318e-01      237.902      66.777     0.806117     3.38249e-03     7.77716e-12
   130.0000     1.60619e+00         1.0000          1.41172e-02       9.76217e-01      237.902      66.175     0.807504     3.24822e-03     5.75954e-12
   127.5000     1.54788e+00         1.0000          1.36664e-02       9.77093e-01      237.902      65.571     0.808878     3.11826e-03     4.24828e-12
   125.0000     1.49131e+00         1.0000          1.32273e-02       9.77946e-01      237.902      64.963     0.810241     2.99252e-03     3.12074e-12
   122.5000     1.43643e+00         1.0000          1.27997e-02       9.78775e-01      237.902      64.352     0.811592     2.87091e-03     2.28289e-12
   120.0000     1.38321e+00         1.0000          1.23834e-02       9.79582e-01      237.902      63.739     0.812931     2.75333e-03     1.66284e-12
   117.5000     1.33162e+00         1.0000          1.19783e-02       9.80367e-01      237.902      63.122     0.814260     2.63967e-03     1.20592e-12
   115.0000     1.28163e+00         1.0000          1.15841e-02       9.81130e-01      237.902      62.502     0.815577     2.52986e-03     8.70644e-13
   112.5000     1.23319e+00         1.0000          1.12006e-02       9.81871e-01      237.902      61.880     0.816882     2.42380e-03     6.25715e-13
   110.0000     1.18628e+00         1.0000          1.08277e-02       9.82590e-01      237.902      61.254     0.818177     2.32139e-03     4.47591e-13
   107.5000     1.14087e+00         1.0000          1.04652e-02       9.83288e-01      237.902      60.626     0.819461     2.22256e-03     3.18646e-13
   105.0000     1.09691e+00         1.0000          1.01128e-02       9.83965e-01      237.902      59.995     0.820734     2.12719e-03     2.25741e-13
   102.5000     1.05439e+00         1.0000          9.77037e-03       9.84622e-01      237.902      59.361     0.821996     2.03522e-03     1.59125e-13
   100.0000     1.01325e+00         1.0000          9.43772e-03       9.85258e-01      237.902      58.724     0.823247     1.94655e-03     1.11594e-13
    97.5000     9.73475e-01         1.0000          9.11466e-03       9.85875e-01      237.902      58.085     0.824488     1.86109e-03     7.78517e-14
    95.0000     9.35027e-01         1.0000          8.80100e-03       9.86472e-01      237.902      57.443     0.825718     1.77877e-03     5.40216e-14
    92.5000     8.97875e-01         1.0000          8.49653e-03       9.87049e-01      237.902      56.799     0.826938     1.69949e-03     3.72806e-14
    90.0000     8.61987e-01         1.0000          8.20108e-03       9.87607e-01      237.902      56.152     0.828148     1.62317e-03     2.55834e-14
    87.5000     8.27330e-01         1.0000          7.91445e-03       9.88147e-01      237.902      55.504     0.829347     1.54974e-03     1.74557e-14
    85.0000     7.93873e-01         1.0000          7.63645e-03       9.88668e-01      237.902      54.853     0.830536     1.47911e-03     1.18402e-14
    82.5000     7.61585e-01         1.0000          7.36690e-03       9.89172e-01      237.902      54.200     0.831716     1.41120e-03     7.98295e-15
    80.0000     7.30435e-01         1.0000          7.10562e-03       9.89658e-01      237.902      53.545     0.832885     1.34593e-03     5.34917e-15
    77.5000     7.00393e-01         1.0000          6.85241e-03       9.90126e-01      237.902      52.889     0.834044     1.28323e-03     3.56175e-15
    75.0000     6.71428e-01         1.0000          6.60709e-03       9.90578e-01      237.902      52.231     0.835194     1.22302e-03     2.35629e-15
    72.5000     6.43511e-01         1.0000          6.36948e-03       9.91013e-01      237.902      51.571     0.836334     1.16523e-03     1.54850e-15
    70.0000     6.16613e-01         1.0000          6.13941e-03       9.91432e-01      237.902      50.910     0.837464     1.10978e-03     1.01074e-15
    67.5000     5.90703e-01         1.0000          5.91668e-03       9.91835e-01      237.902      50.248     0.838585     1.05660e-03     6.55157e-16
    65.0000     5.65755e-01         1.0000          5.70113e-03       9.92223e-01      237.902      49.586     0.839696     1.00561e-03     4.21647e-16
    62.5000     5.41739e-01         1.0000          5.49257e-03       9.92596e-01      237.902      48.922     0.840798     9.56755e-04     2.69385e-16
    60.0000     5.18627e-01         1.0000          5.29083e-03       9.92954e-01      237.902      48.258     0.841891     9.09959e-04     1.70820e-16
    57.5000     4.96394e-01         1.0000          5.09574e-03       9.93297e-01      237.902      47.594     0.842975     8.65155e-04     1.07489e-16
    55.0000     4.75011e-01         1.0000          4.90713e-03       9.93627e-01      237.902      46.929     0.844049     8.22276e-04     6.71062e-17
    52.5000     4.54452e-01         1.0000          4.72482e-03       9.93943e-01      237.902      46.265     0.845115     7.81258e-04     4.15572e-17
    50.0000     4.34692e-01         1.0000          4.54866e-03       9.94246e-01      237.902      45.601     0.846171     7.42038e-04     2.55226e-17
    47.5000     4.15704e-01         1.0000          4.37846e-03       9.94537e-01      237.902      44.938     0.847218     7.04553e-04     1.55419e-17
    45.0000     3.97464e-01         1.0000          4.21408e-03       9.94814e-01      237.902      44.276     0.848257     6.68741e-04     9.38186e-18
    42.5000     3.79948e-01         1.0000          4.05535e-03       9.95080e-01      237.902      43.615     0.849287     6.34543e-04     5.61278e-18
    40.0000     3.63131e-01         1.0000          3.90211e-03       9.95334e-01      237.902      42.955     0.850308     6.01901e-04     3.32712e-18
    37.5000     3.46990e-01         1.0000          3.75419e-03       9.95577e-01      237.902      42.298     0.851321     5.70758e-04     1.95368e-18
    35.0000     3.31502e-01         1.0000          3.61146e-03       9.95808e-01      237.902      41.642     0.852325     5.41057e-04     1.13612e-18
    32.5000     3.16644e-01         1.0000          3.47375e-03       9.96029e-01      237.902      40.988     0.853321     5.12745e-04     6.54135e-19
    30.0000     3.02395e-01         1.0000          3.34092e-03       9.96240e-01      237.902      40.338     0.854309     4.85767e-04     3.72789e-19
    27.5000     2.88732e-01         1.0000          3.21282e-03       9.96441e-01      237.902      39.690     0.855288     4.60073e-04     2.10228e-19
    25.0000     2.75635e-01         1.0000          3.08930e-03       9.96632e-01      237.902      39.045     0.856258     4.35612e-04     1.17280e-19
    22.5000     2.63084e-01         1.0000          2.97022e-03       9.96814e-01      237.902      38.404     0.857221     4.12335e-04     6.47047e-20
    20.0000     2.51058e-01         1.0000          2.85543e-03       9.96987e-01      237.902      37.768     0.858176     3.90193e-04     3.52929e-20
    17.5000     2.39538e-01         1.0000          2.74481e-03       9.97152e-01      237.902      37.135     0.859122     3.69141e-04     1.90257e-20
    15.0000     2.28505e-01         1.0000          2.63822e-03       9.97309e-01      237.902      36.507     0.860061     3.49134e-04     1.01333e-20
    12.5000     2.17940e-01         1.0000          2.53552e-03       9.97457e-01      237.902      35.884     0.860992     3.30126e-04     5.33053e-21
    10.0000     2.07826e-01         1.0000          2.43659e-03       9.97598e-01      237.902      35.267     0.861914     3.12076e-04     2.76848e-21
     7.5000     1.98145e-01         1.0000          2.34130e-03       9.97731e-01      237.902      34.655     0.862829     2.94943e-04     1.41907e-21
     5.0000     1.88880e-01         1.0000          2.24952e-03       9.97858e-01      237.902      34.050     0.863737     2.78687e-04     7.17615e-22
     2.5000     1.80015e-01         1.0000          2.16113e-03       9.97978e-01      237.902      33.451     0.864636     2.63268e-04     3.57875e-22
     0.0000     1.71533e-01         1.0000          2.07601e-03       9.98092e-01      237.902      32.858     0.865528     2.48649e-04     1.75931e-22
    -2.5000     1.63420e-01         1.0000          1.99405e-03       9.98199e-01      237.902      32.273     0.866413     2.34794e-04     8.52201e-23
    -5.0000     1.55660e-01         1.0000          1.91514e-03       9.98300e-01      237.902      31.696     0.867290     2.21668e-04     4.06568e-23
    -7.5000     1.48239e-01         1.0000          1.83916e-03       9.98396e-01      237.902      31.126     0.868160     2.09237e-04     1.90949e-23
   -10.0000     1.41143e-01         1.0000          1.76600e-03       9.98487e-01      237.902      30.565     0.869022     1.97469e-04     8.82439e-24
   -12.5000     1.34358e-01         1.0000          1.69556e-03       9.98573e-01      237.902      30.012     0.869877     1.86331e-04     4.01069e-24
   -15.0000     1.27871e-01         1.0000          1.62773e-03       9.98653e-01      237.902      29.468     0.870725     1.75794e-04     1.79182e-24
   -17.5000     1.21669e-01         1.0000          1.56243e-03       9.98729e-01      237.902      28.934     0.871565     1.65828e-04     7.86458e-25
   -20.0000     1.15741e-01         1.0000          1.49954e-03       9.98801e-01      237.902      28.409     0.872399     1.56405e-04     3.38937e-25
   -22.5000     1.10074e-01         1.0000          1.43898e-03       9.98869e-01      237.902      27.894     0.873225     1.47498e-04     1.43341e-25
   -25.0000     1.04657e-01         1.0000          1.38065e-03       9.98933e-01      237.902      27.390     0.874044     1.39081e-04     5.94520e-26
   -27.5000     9.94791e-02         1.0000          1.32447e-03       9.98992e-01      237.902      26.896     0.874857     1.31129e-04     2.41674e-26
   -30.0000     9.45299e-02         1.0000          1.27035e-03       9.99049e-01      237.902      26.413     0.875662     1.23619e-04     9.62219e-27
   -32.5000     8.97993e-02         1.0000          1.21820e-03       9.99102e-01      237.902      25.941     0.876461     1.16526e-04     3.74971e-27
   -35.0000     8.52775e-02         1.0000          1.16795e-03       9.99152e-01      237.902      25.480     0.877253     1.09829e-04     1.42919e-27
   -37.5000     8.09552e-02         1.0000          1.11951e-03       9.99199e-01      237.902      25.031     0.878038     1.03508e-04     5.32384e-28
   -40.0000     7.68236e-02         1.0000          1.07282e-03       9.99243e-01      237.902      24.594     0.878816     9.75405e-05     1.93669e-28
   -42.5000     7.28742e-02         1.0000          1.02779e-03       9.99284e-01      237.902      24.169     0.879588     9.19088e-05     6.87451e-29
   -45.0000     6.90986e-02         1.0000          9.84366e-04       9.99323e-01      237.902      23.756     0.880353     8.65940e-05     2.37901e-29
   -47.5000     6.54893e-02         1.0000          9.42473e-04       9.99360e-01      237.902      23.356     0.881111     8.15784e-05     8.01929e-30
   -50.0000     6.20387e-02         1.0000          9.02047e-04       9.99394e-01      237.902      22.968     0.881863     7.68453e-05     2.63059e-30
   -52.5000     5.87397e-02         1.0000          8.63026e-04       9.99427e-01      237.902      22.593     0.882608     7.23786e-05     8.38923e-31
   -55.0000     5.55856e-02         1.0000          8.25353e-04       9.99457e-01      237.902      22.230     0.883347     6.81631e-05     2.59835e-31
   -57.5000     5.25698e-02         1.0000          7.88969e-04       9.99486e-01      237.902      21.880     0.884080     6.41842e-05     7.80752e-32
   -60.0000     4.96865e-02         1.0000          7.53822e-04       9.99512e-01      237.902      21.543     0.884806     6.04282e-05     2.27341e-32
   -62.5000     4.69296e-02         1.0000          7.19860e-04       9.99538e-01      237.902      21.219     0.885526     5.68819e-05     6.40736e-33
   -65.0000     4.42937e-02         1.0000          6.87035e-04       9.99561e-01      237.902      20.907     0.886240     5.35329e-05     1.74573e-33
   -67.5000     4.17737e-02         1.0000          6.55301e-04       9.99584e-01      237.902      20.608     0.886948     5.03694e-05     4.59207e-34
   -70.0000     3.93645e-02         1.0000          6.24614e-04       9.99605e-01      237.902      20.322     0.887649     4.73804e-05     1.16460e-34
   -72.5000     3.70616e-02         1.0000          5.94934e-04       9.99625e-01      237.902      20.049     0.888344     4.45553e-05     2.84351e-35
   -75.0000     3.48606e-02         1.0000          5.66222e-04       9.99644e-01      237.902      19.787     0.889033     4.18841e-05     6.67406e-36
   -77.5000     3.27573e-02         1.0000          5.38444e-04       9.99662e-01      237.902      19.538     0.889717     3.93576e-05     1.50344e-36
   -80.0000     3.07478e-02         1.0000          5.11566e-04       9.99678e-01      237.902      19.301     0.890394     3.69669e-05     3.24503e-37
   -82.5000     2.88285e-02         1.0000          4.85557e-04       9.99694e-01      237.902      19.076     0.891065     3.47039e-05     6.69910e-38
   -85.0000     2.69960e-02         1.0000          4.60389e-04       9.99709e-01      237.902      18.863     0.891730     3.25608e-05     1.32029e-38
   -87.5000     2.52470e-02         1.0000          4.36038e-04       9.99724e-01      237.902      18.661     0.892389     3.05304e-05     2.47928e-39
   -90.0000     2.35785e-02         1.0000          4.12478e-04       9.99738e-01      237.902      18.470     0.893043     2.86060e-05     4.42670e-40
   -92.5000     2.19877e-02         1.0000          3.89690e-04       9.99751e-01      237.902      18.290     0.893690     2.67814e-05     7.49856e-41
   -95.0000     2.04720e-02         1.0000          3.67654e-04       9.99763e-01      237.902      18.121     0.894332     2.50507e-05     1.20229e-41
   -97.5000     1.90288e-02         1.0000          3.46354e-04       9.99775e-01      237.902      17.962     0.894968     2.34086e-05     1.82017e-42
  -100.0000     1.76559e-02         1.0000          3.25775e-04       9.99786e-01      237.902      17.813     0.895599     2.18502e-05     2.59505e-43
  -102.5000     1.63510e-02         1.0000          3.05904e-04       9.99797e-01      237.902      17.673     0.896224     2.03709e-05     3.47470e-44
  -105.0000     1.51120e-02         1.0000          2.86730e-04       9.99808e-01      237.902      17.543     0.896843     1.89665e-05     4.35664e-45
  -107.5000     1.39370e-02         1.0000          2.68243e-04       9.99818e-01      237.902      17.423     0.897456     1.76333e-05     5.09912e-46
  -110.0000     1.28242e-02         1.0000          2.50437e-04       9.99828e-01      237.902      17.310     0.898064     1.63677e-05     5.55282e-47
  -112.5000     1.17717e-02         1.0000          2.33305e-04       9.99837e-01      237.902      17.207     0.898667     1.51666e-05     5.60631e-48
  -115.0000     1.07779e-02         1.0000          2.16842e-04       9.99846e-01      237.902      17.111     0.899263     1.40272e-05     5.22826e-49
  -117.5000     9.84117e-03         1.0000          2.01043e-04       9.99855e-01      237.902      17.023     0.899855     1.29468e-05     4.48559e-50
  -120.0000     8.95986e-03         1.0000          1.85906e-04       9.99864e-01      237.902      16.942     0.900441     1.19230e-05     3.52543e-51
  -122.5000     8.13245e-03         1.0000          1.71428e-04       9.99872e-01      237.902      16.869     0.901021     1.09539e-05     2.52672e-52
  -125.0000     7.35740e-03         1.0000          1.57607e-04       9.99880e-01      237.902      16.803     0.901596     1.00374e-05     1.64339e-53
  -127.5000     6.63319e-03         1.0000          1.44441e-04       9.99888e-01      237.902      16.743     0.902166     9.17190e-06     9.64934e-55
  -130.0000     5.95829e-03         1.0000          1.31928e-04       9.99895e-01      237.902      16.690     0.902730     8.35576e-06     5.08633e-56
  -132.5000     5.33118e-03         1.0000          1.20066e-04       9.99903e-01      237.902      16.642     0.903290     7.58756e-06     2.39253e-57
  -135.0000     4.75029e-03         1.0000          1.08853e-04       9.99910e-01      237.902      16.601     0.903843     6.86598e-06     9.97845e-59
  -137.5000     4.21404e-03         1.0000          9.82848e-05       9.99917e-01      237.902      16.565     0.904392     6.18977e-06     3.66449e-60
  -140.0000     3.72081e-03         1.0000          8.83575e-05       9.99923e-01      237.902      16.535     0.904935     5.55774e-06     1.17617e-61
  -142.5000     3.26895e-03         1.0000          7.90655e-05       9.99930e-01      237.902      16.510     0.905473     4.96876e-06     3.27298e-63
  -145.0000     2.85673e-03         1.0000          7.04018e-05       9.99936e-01      237.902      16.491     0.906006     4.42169e-06     7.82818e-65
  -147.5000     2.48241e-03         1.0000          6.23578e-05       9.99942e-01      237.902      16.477     0.906534     3.91539e-06     1.59421e-66
  -150.0000     2.14417e-03         1.0000          5.49230e-05       9.99947e-01      237.902      16.468     0.907057     3.44870e-06     2.73640e-68
  -152.5000     1.84015e-03         1.0000          4.80849e-05       9.99953e-01      237.902      16.465     0.907574     3.02040e-06     3.91538e-70
  -155.0000     1.56846e-03         1.0000          4.18290e-05       9.99958e-01      237.902      16.467     0.908086     2.62925e-06     4.61445e-72
  -157.5000     1.32714e-03         1.0000          3.61382e-05       9.99962e-01      237.902      16.475     0.908594     2.27388e-06     4.42131e-74
  -159.8987     1.12232e-03         1.0000          3.11917e-05       9.99967e-01      237.902      16.488     0.909076     1.96523e-06     4.15422e-76
  -159.8987     1.12232e-03         1.0000          3.11917e-05       2.69026e-05      237.902     201.651     0.909076     8.93398e-01     4.18197e-01
  -159.8987     2.33406e-03         1.0000          6.48685e-05       5.59487e-05      237.902     201.651     0.909076     8.93398e-01     4.18197e-01
  -159.8987     4.85409e-03         1.0000          1.34905e-04       1.16355e-04      237.902     201.651     0.909076     8.93398e-01     4.18197e-01
  -159.8987     1.00949e-02         1.0000          2.80559e-04       2.41981e-04      237.902     201.651     0.909076     8.93398e-01     4.18197e-01
  -159.8987     2.09942e-02         1.0000          5.83471e-04       5.03241e-04      237.902     201.651     0.909076     8.93399e-01     4.18197e-01
  -159.8986     4.36610e-02         1.0000          1.21343e-03       1.04658e-03      237.902     201.651     0.909076     8.93399e-01     4.18197e-01
  -159.8984     9.08007e-02         1.0000          2.52353e-03       2.17653e-03      237.902     201.651     0.909076     8.93399e-01     4.18196e-01
  -159.8979     1.88836e-01         1.0000          5.24810e-03       4.52645e-03      237.902     201.651     0.909077     8.93400e-01     4.18195e-01
  -159.8970     3.92717e-01         1.0000          1.09142e-02       9.41344e-03      237.902     201.651     0.909079     8.93402e-01     4.18193e-01
  -159.8952     8.16723e-01         1.0000          2.26976e-02       1.95765e-02      237.902     201.650     0.909083     8.93406e-01     4.18188e-01
  -159.8913     1.69852e+00         1.0000          4.72016e-02       4.07108e-02      237.902     201.649     0.909090     8.93413e-01     4.18178e-01
  -159.8833     3.53237e+00         1.0000          9.81553e-02       8.46569e-02      237.902     201.648     0.909105     8.93429e-01     4.18157e-01
  -159.8666     7.34617e+00         1.0000          2.04094e-01       1.76023e-01      237.902     201.644     0.909137     8.93463e-01     4.18113e-01
  -159.8322     1.52776e+01         1.0000          4.24289e-01       3.65919e-01      237.902     201.637     0.909202     8.93531e-01     4.18023e-01
  -159.7612     3.17725e+01         1.0000          8.81700e-01       7.60342e-01      237.902     201.623     0.909337     8.93672e-01     4.17838e-01
  -159.6167     6.60765e+01         1.0000          1.83076e+00       1.57851e+00      237.902     201.594     0.909611     8.93959e-01     4.17458e-01
  -159.3283     1.37418e+02         1.0000          3.79549e+00       3.27144e+00      237.902     201.535     0.910152     8.94527e-01     4.16696e-01
  -158.7768     2.85784e+02         1.0000          7.84653e+00       6.75880e+00      237.902     201.420     0.911171     8.95596e-01     4.15219e-01
  -157.8010     5.94337e+02         1.0000          1.61491e+01       1.38942e+01      237.902     201.212     0.912924     8.97437e-01     4.12543e-01
  -156.2900     1.23603e+03         1.0000          3.30565e+01       2.83877e+01      237.902     200.875     0.915524     9.00168e-01     4.08226e-01
  -154.3706     2.57053e+03         1.0000          6.74064e+01       5.77408e+01      237.902     200.418     0.918640     9.03447e-01     4.02412e-01
  -152.4612     5.34587e+03         1.0000          1.37529e+02       1.17495e+02      237.902     199.930     0.921553     9.06516e-01     3.96242e-01
  -150.9728     1.11177e+04         1.0000          2.81874e+02       2.40284e+02      237.902     199.525     0.923706     9.08789e-01     3.91158e-01
  -150.0192     2.31211e+04         1.0000          5.80829e+02       4.94403e+02      237.902     199.254     0.925036     9.10194e-01     3.87772e-01
  -149.4831     4.80845e+04         1.0000          1.20175e+03       1.02207e+03      237.902     199.098     0.925767     9.10967e-01     3.85825e-01
  -149.2037     1.00000e+05         1.0000          2.49260e+03       2.11897e+03      237.902     199.015     0.926144     9.11365e-01     3.84798e-01
END

set output "Figures/Env_001_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:6.0e+01] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_001_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_001_LogP_vs_TI_1.pdf"
set xlabel "1/Temperature (1/K)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using (1/($1+273.15)):2 with lines title "Dew Points", \
     $Env_BP using (1/($1+273.15)):2 with lines title "Bubble Points"
unset logscale y

set output
